package parser;

/**
 * Factory for I grammar non-terminal objects.
 */
public class IFact extends ATVFactory {
    /**
     * Initializer lambda for this factory.
     */
    private ILambda _initializer = new ILambda() {
        public Object apply(Object param) {
            // change state to no-op
            _initializer = NoOpLambda.Singleton;

            // nothing to initialize
            return null;
        }
    };

    /**
     * Constructor for the I factory.
     *
     * @param tkz tokenizer to use
     */
    public IFact(ITokenizer tkz) {
        super(tkz);
    }

    /**
     * Make the visitor.
     */
    private void initialize() {
        _initializer.apply(null);
    }

    /**
     * Make a token visitor to parse an I non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        initialize();
        return new IdToken.IIdVisitor() {
            public Object idCase(IdToken host, Object inp) {
                return new I(host);
            }

            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Wrong token: '" + host + "'");
            }
        };
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        initialize();
        return new IdToken.AChainVis(successor) {
            public Object idCase(IdToken host, Object inp) {
                return new I(host);
            }
        };
    }
}

